/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.lib.visualization;

import dev.engine_room.flywheel.api.visual.Effect;
import dev.engine_room.flywheel.api.visualization.BlockEntityVisualizer;
import dev.engine_room.flywheel.api.visualization.EntityVisualizer;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import dev.engine_room.flywheel.api.visualization.VisualizerRegistry;
import net.minecraft.class_1297;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2586;
import org.jetbrains.annotations.Nullable;

public final class VisualizationHelper {
    private VisualizationHelper() {
    }

    public static void queueAdd(Effect effect) {
        VisualizationManager manager = VisualizationManager.get(effect.level());
        if (manager == null) {
            return;
        }
        manager.effects().queueAdd(effect);
    }

    public static void queueRemove(Effect effect) {
        VisualizationManager manager = VisualizationManager.get(effect.level());
        if (manager == null) {
            return;
        }
        manager.effects().queueRemove(effect);
    }

    public static void queueUpdate(class_2586 blockEntity) {
        class_1937 level = blockEntity.method_10997();
        VisualizationManager manager = VisualizationManager.get((class_1936)level);
        if (manager == null) {
            return;
        }
        manager.blockEntities().queueUpdate(blockEntity);
    }

    public static void queueUpdate(class_1297 entity) {
        class_1937 level = entity.method_37908();
        VisualizationManager manager = VisualizationManager.get((class_1936)level);
        if (manager == null) {
            return;
        }
        manager.entities().queueUpdate(entity);
    }

    public static void queueUpdate(Effect effect) {
        VisualizationManager manager = VisualizationManager.get(effect.level());
        if (manager == null) {
            return;
        }
        manager.effects().queueUpdate(effect);
    }

    @Nullable
    public static <T extends class_2586> BlockEntityVisualizer<? super T> getVisualizer(T blockEntity) {
        return VisualizerRegistry.getVisualizer(blockEntity.method_11017());
    }

    @Nullable
    public static <T extends class_1297> EntityVisualizer<? super T> getVisualizer(T entity) {
        return VisualizerRegistry.getVisualizer(entity.method_5864());
    }

    public static <T extends class_2586> boolean canVisualize(T blockEntity) {
        return VisualizationHelper.getVisualizer(blockEntity) != null;
    }

    public static <T extends class_1297> boolean canVisualize(T entity) {
        return VisualizationHelper.getVisualizer(entity) != null;
    }

    public static <T extends class_2586> boolean skipVanillaRender(T blockEntity) {
        BlockEntityVisualizer<T> visualizer = VisualizationHelper.getVisualizer(blockEntity);
        if (visualizer == null) {
            return false;
        }
        return visualizer.skipVanillaRender(blockEntity);
    }

    public static <T extends class_1297> boolean skipVanillaRender(T entity) {
        EntityVisualizer<T> visualizer = VisualizationHelper.getVisualizer(entity);
        if (visualizer == null) {
            return false;
        }
        return visualizer.skipVanillaRender(entity);
    }

    public static <T extends class_2586> boolean tryAddBlockEntity(T blockEntity) {
        class_1937 level = blockEntity.method_10997();
        VisualizationManager manager = VisualizationManager.get((class_1936)level);
        if (manager == null) {
            return false;
        }
        BlockEntityVisualizer<T> visualizer = VisualizationHelper.getVisualizer(blockEntity);
        if (visualizer == null) {
            return false;
        }
        manager.blockEntities().queueAdd(blockEntity);
        return visualizer.skipVanillaRender(blockEntity);
    }
}

